VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Edge Gated Pulse Generation with KPCI3100 Series"
   ClientHeight    =   8880
   ClientLeft      =   2010
   ClientTop       =   1590
   ClientWidth     =   7815
   LinkTopic       =   "Form1"
   ScaleHeight     =   8880
   ScaleWidth      =   7815
   Begin VB.CommandButton cmdHelp 
      Caption         =   "Help"
      Height          =   495
      Left            =   5880
      TabIndex        =   25
      Top             =   600
      Width           =   1215
   End
   Begin VB.TextBox txtStatus 
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   480
      TabIndex        =   24
      Top             =   6480
      Width           =   6255
   End
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   2160
      TabIndex        =   22
      Text            =   "0"
      Top             =   960
      Width           =   615
   End
   Begin VB.CommandButton cmdOpen 
      Caption         =   "Open Driver"
      Height          =   495
      Left            =   480
      TabIndex        =   21
      Top             =   840
      Width           =   1215
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   5880
      TabIndex        =   20
      Top             =   7440
      Width           =   1215
   End
   Begin VB.Frame Frame4 
      Caption         =   "Pulse Info (Tics of the Internal 20MHz timebase)"
      Height          =   1695
      Left            =   480
      TabIndex        =   16
      Top             =   3960
      Width           =   4935
      Begin VB.Label Label7 
         BackColor       =   &H8000000E&
         Height          =   255
         Left            =   240
         TabIndex        =   19
         Top             =   1320
         Width           =   4335
      End
      Begin VB.Label Label6 
         BackColor       =   &H8000000E&
         Height          =   255
         Left            =   240
         TabIndex        =   18
         Top             =   840
         Width           =   4335
      End
      Begin VB.Label Label5 
         BackColor       =   &H8000000E&
         Height          =   255
         Left            =   240
         TabIndex        =   17
         Top             =   360
         Width           =   4335
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Pulse Timing"
      Height          =   1335
      Left            =   4680
      TabIndex        =   9
      Top             =   2400
      Width           =   2775
      Begin VB.TextBox txtDuration 
         Height          =   285
         Left            =   1800
         TabIndex        =   13
         Text            =   "1"
         ToolTipText     =   "Sum of Duration and Delay can not exceed 3.2 msec"
         Top             =   360
         Width           =   735
      End
      Begin VB.TextBox txtDelay 
         Height          =   285
         Left            =   1800
         TabIndex        =   11
         Text            =   "0.1"
         ToolTipText     =   "Sum of Duration and Delay can not exceed 3.2 msec"
         Top             =   720
         Width           =   735
      End
      Begin VB.Label Label4 
         Caption         =   "Duration (msec)"
         Height          =   255
         Left            =   120
         TabIndex        =   12
         Top             =   360
         Width           =   1215
      End
      Begin VB.Label Label3 
         Caption         =   "Delay (msec)"
         Height          =   255
         Left            =   120
         TabIndex        =   10
         Top             =   720
         Width           =   1215
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Gate Edge Select"
      Height          =   1095
      Left            =   2640
      TabIndex        =   7
      Top             =   2400
      Width           =   1815
      Begin VB.OptionButton optFallling 
         Caption         =   "Falling Edge"
         Height          =   255
         Left            =   240
         TabIndex        =   15
         Top             =   600
         Width           =   1455
      End
      Begin VB.OptionButton optRising 
         Caption         =   "Rising Edge"
         Height          =   255
         Left            =   240
         TabIndex        =   14
         Top             =   240
         Value           =   -1  'True
         Width           =   1335
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Pulse Polarity"
      Height          =   1095
      Left            =   480
      TabIndex        =   4
      Top             =   2400
      Width           =   1815
      Begin VB.OptionButton optLO 
         Caption         =   "Acive Lo"
         Height          =   255
         Left            =   240
         TabIndex        =   6
         Top             =   600
         Value           =   -1  'True
         Width           =   975
      End
      Begin VB.OptionButton optHI 
         Caption         =   "Active Hi"
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   240
         Width           =   975
      End
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      Enabled         =   0   'False
      Height          =   495
      Left            =   2040
      TabIndex        =   2
      Top             =   1680
      Width           =   1215
   End
   Begin VB.Timer Timer1 
      Left            =   3960
      Top             =   1560
   End
   Begin DlsrLib.DriverLINXSR DriverLINXSR2 
      Left            =   3960
      Top             =   360
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.TextBox Text1 
      Enabled         =   0   'False
      Height          =   285
      Left            =   3240
      TabIndex        =   1
      Text            =   "0"
      Top             =   6000
      Width           =   735
   End
   Begin DlsrLib.DriverLINXSR DriverLINXSR1 
      Left            =   3960
      Top             =   960
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Enabled         =   0   'False
      Height          =   495
      Left            =   480
      TabIndex        =   0
      Top             =   1680
      Width           =   1215
   End
   Begin VB.Label Label8 
      AutoSize        =   -1  'True
      Caption         =   "Device Number :"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   165
      Left            =   2160
      TabIndex        =   23
      Top             =   720
      Width           =   1260
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Number of Pulses Detected :"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000C&
      Height          =   195
      Left            =   600
      TabIndex        =   8
      Top             =   6000
      Width           =   2580
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   360
      Left            =   480
      TabIndex        =   3
      Top             =   240
      Width           =   1845
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
' this example was written in VB6
' it was tested using a KPCI-3104 with 3100-850A03 driver in Win2KSP1
'
' it programs counter channel 0 to generate a pulse of programmable duration after
' programmable delay.  An edge at the Gate is required.
'
'
' a second counter, channel 1, is used in simple event counting mode
' to indicate that a pulse has taken place.....
'
' for the purpose of testing, AIOPanel was launced and a digital channel was
' assigned to the output subsystem and then the AIOPanel was used to toggle this
' bit to generate the gating edges (connect this digital bit to the gate of counter 0)
'

Private Sub cmdExit_Click()
' stop any active tasks
DriverLINXSR1.Req_op = DL_STOP
DriverLINXSR1.Refresh
DriverLINXSR2.Req_op = DL_STOP
DriverLINXSR2.Refresh
Timer1.Enabled = False
' unload drivers
DriverLINXSR1.Req_DLL_name = ""
DriverLINXSR2.Req_DLL_name = ""
End  ' exit this program
End Sub

Private Sub cmdHelp_Click()
Form2.Show
Form1.Hide
End Sub

Private Sub cmdOpen_Click()
Dim DeviceNumber As Integer
DeviceNumber = CInt(devNum.Text)
With DriverLINXSR1
.Req_DLL_name = "kpci3100"
.Req_device = DeviceNumber
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Req_mode = DL_OTHER
.Refresh
End With
If DriverLINXSR1.Res_result = DL_NoErr Then
DriverLINXSR2.Req_DLL_name = DriverLINXSR1.Req_DLL_name  ' second SR uses same hardware
DriverLINXSR1.Req_device = DriverLINXSR1.Req_device
cmdOpen.Enabled = False
cmdStart.Enabled = True
Else
MsgBox DriverLINXSR1.Message, vbOKOnly, "Error Initializing the hardware"
End If
' set focus back to our form
Form1.SetFocus

End Sub

' page 104 of the ctmguide.pdf
Private Sub cmdStart_Click()
txtStatus.Text = " "
Dim duration As Single
Dim delay As Single
Text1.Text = 0
cmdStart.Enabled = False
cmdStop.Enabled = True
With DriverLINXSR1
.Req_op = DL_START
.Req_mode = DL_POLLED
.Req_subsystem = DL_CT
.Evt_Str_type = DL_NULLEVENT
.Evt_Stp_type = DL_NULLEVENT

.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateClock = DL_INTERNAL1
.Evt_Tim_rateChannel = 0
If optRising.Value = True Then
.Evt_Tim_rateGate = HIEDGEGATEN  ' rising edge at gate triggers the pulse
Else
.Evt_Tim_rateGate = LOEDGEGATEN  ' falling edge at gate triggers the pulse
'.Evt_Tim_rateGate = HITCNm1   ' what is this?
End If
' MODE:
' DL_PULSEGEN = pulse of programmable duration and delay via the onCount and period
' properties

.Evt_Tim_rateMode = DL_PULSEGEN
' the delay and pulse width info is in the Period and onCount properties
' the sum of these two can not exceed 65535, but they can sum to less than 65535 too
'
' the internal timebase (internal1) is 20MHz; the tics happen at 50 nano second intervals
' 65535 * 50E-09 = 0.0032 seconds (3.2 msec)
'
' delay needs to be at least 1 tic
' pulse duration can be no longer than 65534 tics
'
'
delay = CSng(txtDelay.Text) / 1000   ' they are entered as mseconds on the form
duration = CSng(txtDuration.Text) / 1000  ' convert to seconds for the .DLSecs2Tics method

.Evt_Tim_ratePeriod = .DLSecs2Tics(.Evt_Tim_rateClock, delay) 'delay before pulse fires
.Evt_Tim_rateOnCount = .DLSecs2Tics(.Evt_Tim_rateClock, duration) ' duration of the pulse

If .Evt_Tim_ratePeriod = 0 Then .Evt_Tim_ratePeriod = 1 ' delay can be zero tics. Must be at least 1

If .Evt_Tim_rateOnCount < 3 Then .Evt_Tim_rateOnCount = 2 ' pulse duration must be at least 2 tics

Label5.Caption = "Duration of Pulse is : " & Str(.Evt_Tim_rateOnCount) & " Tics"
Label6.Caption = "Delay before the Pulse is : " & Str(.Evt_Tim_ratePeriod) & " Tics"
Label7.Caption = "Sum of Delay and Duration is : " & Str(.Evt_Tim_rateOnCount + .Evt_Tim_ratePeriod) & " Tics"
If (.Evt_Tim_rateOnCount + .Evt_Tim_ratePeriod) > 65535 Then
MsgBox "Reduce the delay or the duration.", vbOKOnly
Exit Sub
End If

' code below will program the output of the counter to be an active high or active low pulse
'
' if active high, the output of the counter will not go low until the task is made active.
' when the task is stopped, the output will return to it's default logic 1 state.  The system
' design needs to take this into account.
'
' It might be easier to design for an acive low pulse
'
If optLO.Value = True Then
.Evt_Tim_rateOutput = CT_Output_LoActive
Else
.Evt_Tim_rateOutput = CT_Output_HiActive
End If
.Evt_Tim_ratePulses = 0  ' 1 = one time only must call .Refresh again and again
                         ' 0 = new gate edge causes new pulse
'.Req_op_edit = True
'.Refresh
.Refresh
End With
If DriverLINXSR1.Res_result = DL_NoErr Then
txtStatus.Text = "Waiting for edge signal at gate...."
Else
txtStatus.Text = DriverLINXSR1.Message
End If

With DriverLINXSR2
' set up event counting on channel 1 to act as our witness that the pulse
' has happened
.Req_device = CInt(devNum.Text)
.Req_subsystem = DL_CT
.Req_mode = DL_POLLED
.Req_op = DL_START
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = 1
.Evt_Tim_rateMode = DL_COUNT
.Evt_Tim_rateClock = DL_TCNm1 ' internal cascade from previous chan; no jumper wire needed
.Evt_Tim_rateGate = DL_DISABLED
.Evt_Tim_ratePeriod = 0
.Evt_Tim_rateOnCount = 0
.Evt_Tim_ratePulses = 0  ' continuous
.Evt_Tim_rateOutput = CT_Output_Default
.Evt_Str_type = DL_NULLEVENT
.Evt_Stp_type = DL_NULLEVENT
.Res_Sta_typeStatus = DL_TIMERSTATUS
.Sel_buf_N = 0
.Sel_chan_N = 0
.Refresh
End With
showMessage DriverLINXSR2

Timer1.Interval = 500  ' 0.5 second
Timer1.Enabled = True  ' enable a timer object from which we'll read the counts
End Sub

Private Sub cmdStop_Click()
cmdStart.Enabled = True
cmdStop.Enabled = False
' stop any active tasks
DriverLINXSR1.Req_op = DL_STOP
DriverLINXSR1.Refresh
DriverLINXSR2.Req_op = DL_STOP
DriverLINXSR2.Refresh
Timer1.Enabled = False
txtStatus.Text = "Task is no longer active.  Push Start Button to restart."
End Sub

Private Sub Form_Load()
Dim i As Integer
'populate combo box with legal device numbers..
For i = 0 To 5
devNum.AddItem Str(i), i
Next i
' set combo box equal to first entry
devNum.ListIndex = 0
' hide the help form
Form2.Hide
End Sub

Sub showMessage(SR As Control)
If (SR.Res_result <> DL_NoErr) Then
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
' stop any active tasks
DriverLINXSR1.Req_op = DL_STOP
DriverLINXSR1.Refresh
DriverLINXSR2.Req_op = DL_STOP
DriverLINXSR2.Refresh
' unload drivers
DriverLINXSR1.Req_DLL_name = ""
DriverLINXSR2.Req_DLL_name = ""

End Sub


Private Sub Timer1_Timer()
'read the counts on C/T1, e.g., the pulse witness channel
With DriverLINXSR2
.Req_op = DL_STATUS
.Refresh
Text1.Text = .Res_Tim_count
End With
If DriverLINXSR2.Res_Tim_count > 0 Then
txtStatus.Text = "The Pulse from CT0 has been detected by CT1"
Else
txtStatus.Text = "Waiting for edge signal at gate...."
End If
'Beep
End Sub
